<!--
// BEGIN --- Cookie's functions Quick List ---

function readCookie(name) {
	var eq = name + "=";
	var ca = document.cookie.split(';');
	if (!ca.length) return null;
	for (var i=0;i<ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(eq) == 0) return unescape(c.substring(eq.length,c.length));
	}
	return null;
}

function includeInCookie(property_id, edir_path) {
	var name = "bookmark";
	var d = new Date();
	if (!edir_path) edir_path = "/";
	d.setTime(d.getTime() + (15*24*60*60*1000));
	var expires = '; expires=' + d.toGMTString();
	var bookmark = readCookie("bookmark");
	if (!bookmark) bookmark = "'" + property_id + "'";
	else {
		if (bookmark.indexOf("'" + property_id + "'") == -1) {
			bookmark = bookmark + "," + "'" + property_id + "'";
		}
	}
	document.cookie = name + '=' + escape(bookmark) + expires + '; path=' + edir_path;
	alert ("This listing was added to your Quick List\n\nYou can view your Quick List by clicking on 'View Quick List' link.");
}

function removeFromCookie(property_id, edir_path) {
	var name = "bookmark";
	var d = new Date();
	if (!edir_path) edir_path = "/";
	d.setTime(d.getTime() + (15*24*60*60*1000));
	var expires = '; expires=' + d.toGMTString();
	if (isNaN(property_id)) {
		if (property_id == "all") {
			var bookmark = "";
			document.cookie = name + '=' + escape(bookmark) + expires + '; path=' + edir_path;
		}
	} else {
		var bookmark = readCookie("bookmark");
		if (bookmark.length > 0) {
			if (bookmark.indexOf("'" + property_id + "'") > -1) {
				finalvar = bookmark.indexOf("'" + property_id + "'") + property_id.length + 3;
				var aux = "";
				aux = bookmark.substr(0, bookmark.indexOf("'" + property_id + "'"));
				aux += bookmark.substr(finalvar);
				bookmark = aux;
			}
		}
		len = bookmark.length;
		len--;
		if (bookmark.lastIndexOf(",") == len) {
			bookmark = bookmark.substr(0, len);
		}
		document.cookie = name + '=' + escape(bookmark) + expires + '; path=' + edir_path;
		alert ("This listing was removed from your Quick List");
	}
	window.location.reload();
}

function includeClassifiedInCookie(property_id, edir_path) {
	var name = "classifiedbookmark";
	var d = new Date();
	if (!edir_path) edir_path = "/";
	d.setTime(d.getTime() + (15*24*60*60*1000));
	var expires = '; expires=' + d.toGMTString();
	var classifiedbookmark = readCookie("classifiedbookmark");
	if (!classifiedbookmark) classifiedbookmark = "'" + property_id + "'";
	else {
		if (classifiedbookmark.indexOf("'" + property_id + "'") == -1) {
			classifiedbookmark = classifiedbookmark + "," + "'" + property_id + "'";
		}
	}
	document.cookie = name + '=' + escape(classifiedbookmark) + expires + '; path=' + edir_path;
	alert ("This classified was added to your Quick List\n\nYou can view your Quick List by clicking on 'View Quick List' link.");
}

function removeClassifiedFromCookie(property_id, edir_path) {
	var name = "classifiedbookmark";
	var d = new Date();
	if (!edir_path) edir_path = "/";
	d.setTime(d.getTime() + (15*24*60*60*1000));
	var expires = '; expires=' + d.toGMTString();
	if (isNaN(property_id)) {
		if (property_id == "all") {
			var classifiedbookmark = "";
			document.cookie = name + '=' + escape(classifiedbookmark) + expires + '; path=' + edir_path;
		}
	} else {
		var classifiedbookmark = readCookie("classifiedbookmark");
		if (classifiedbookmark.length > 0) {
			if (classifiedbookmark.indexOf("'" + property_id + "'") > -1) {
				finalvar = classifiedbookmark.indexOf("'" + property_id + "'") + property_id.length + 3;
				var aux = "";
				aux = classifiedbookmark.substr(0, classifiedbookmark.indexOf("'" + property_id + "'"));
				aux += classifiedbookmark.substr(finalvar);
				classifiedbookmark = aux;
			}
		}
		len = classifiedbookmark.length;
		len--;
		if (classifiedbookmark.lastIndexOf(",") == len) {
			classifiedbookmark = classifiedbookmark.substr(0, len);
		}
		document.cookie = name + '=' + escape(classifiedbookmark) + expires + '; path=' + edir_path;
		alert ("This classified was removed from your Quick List");
	}
	window.location.reload();
}

// END --- Cookie's functions Quick List ---
//-->
